
#R script for the analyses of the paper titled "The Susceptibility of Compound Remote Associate Problems to Disruption by Irrelevant Sound:
#A Window onto the Component Processes Underpinning Creative Cognition? submitted to Journal of Cognitive Psychology.

#### LIBRARIES ####
#Install
install.packages("languageR") 
install.packages("lme4")
install.packages("lattice") 
install.packages("lmerTest")
install.packages("MASS") 
install.packages("plyr")
install.packages("pbkrtest")
install.packages("effects")

#Upload
library(languageR)
library(lme4)
library(lattice)
library(lmerTest)
library(MASS)
library(plyr)
library(pbkrtest)
library(effects)

#### SOLUTION RATES ####
#### EXPERIMENT 1 ####
#### 1. Set up working directory and data to use ####
rm(list=ls()) # Remove any variables
setwd("C:/Users/Federica/Documents/UCLan/research/John Marsh/JCognitivePsychology") # Set the working directory
getwd()

datafile = read.csv("Experiment1.csv", header=TRUE,sep = ",",dec=".") # Replace the name of the file with the one that you're analysing
head(datafile) # Generally check the file you have imported

#Rename column 'condition' with 'Sound'
colnames(datafile)[5] <- "Sound"
head(datafile)

#Create a new variable 'newcondition'
datafile$newcondition[datafile$Sound == "Quiet" & datafile$Difficulty== "Easy"] <-1
datafile$newcondition[datafile$Sound == "Quiet" & datafile$Difficulty== "Hard"] <-2
datafile$newcondition[datafile$Sound == "SS" & datafile$Difficulty== "Easy"] <-3
datafile$newcondition[datafile$Sound == "SS" & datafile$Difficulty== "Hard"] <-4
datafile$newcondition[datafile$Sound == "CS" & datafile$Difficulty=="Easy"] <-5
datafile$newcondition[datafile$Sound == "CS" & datafile$Difficulty== "Hard"] <-6
head(datafile)

table(datafile$newcondition) #cond1: 480; cond2: 432; cond3: 480; cond4: 432; cond5: 480; cond6: 432.
table(datafile$Sound) #CS: 912, quiet: 912, SS: 912.
table(datafile$Difficulty) #Easy: 1440, Hard: 1296.

#### 2. Set up variables ####
colnames(datafile) #checked the column names
col.subject =1   # specify which column your participant number is in
col.condition =9 # specify which column contains your condition number ('newcondition' column)
col.stim =3 # specify which column your item number is in
measure =  "correct" # choose dependent variable, replace the name of the measure with the one that you're analysing

#Add to dataframe the DV
datafile$depvar = datafile[,measure]
head(datafile) # Generally check the file

#Add to dataframe fixed and random factors columns
datafile$pp = datafile[,col.subject]
datafile$condition = datafile[,col.condition]
datafile$stim = datafile[,col.stim]
head(datafile) # Generally check the file

#Make sure all variables are correct class
datafile$depvar = as.numeric(datafile$depvar)
datafile$stim = as.factor(datafile$stim)
datafile$condition = as.factor(datafile$condition)
datafile$Sound = as.factor(datafile$Sound)
datafile$Difficulty = as.factor(datafile$Difficulty)
datafile$Set = as.factor(datafile$Set)
str(datafile)

#### 3. Means,Standard Deviations and Standard Errors ####
#Step1a: make a matrix with the means per subject and per condition for the dependent variable
mean.matrix = tapply(datafile$depvar, list(datafile$pp, datafile$condition), mean, na.rm = T)
mean.matrix

#Step1b: make a matrix with the standard deviations per subject and per condition for the dependent variable
sd.matrix = tapply(datafile$depvar, list(datafile$pp, datafile$condition), sd, na.rm = T)
sd.matrix

#Step2:Calculate the grand mean by condition 
grand.mean=apply(mean.matrix, 2, mean, na.rm = T)
grand.mean
grand.sd=apply(mean.matrix,2,sd, na.rm = T)
grand.sd
grand.se=grand.sd/sqrt(48) ##The number of the participants is 48. 
grand.se

sink("Experiment1_SolutionRate_Means&SD&SE.txt")
grand.mean
grand.sd
grand.se
sink()

#### 4. Linear Mixed Models (LMM)####
#Step1: Check the levels of Difficulty and Sound
head(datafile) # Generally check the file
levels(datafile$Difficulty) # "Easy", "Hard"
levels(datafile$Difficulty)[match("Easy",levels(datafile$Difficulty))] <- "1Easy"
levels(datafile$Difficulty)[match("Hard",levels(datafile$Difficulty))] <- "2Hard"
levels(datafile$Difficulty) # "1Easy", "2Hard"

levels(datafile$Sound) # "CS"    "Quiet" "SS"  
levels(datafile$Sound)[match("Quiet",levels(datafile$Sound))] <- "1Quiet"
levels(datafile$Sound)[match("SS",levels(datafile$Sound))] <- "2SS"
levels(datafile$Sound)[match("CS",levels(datafile$Sound))] <- "3CS"
datafile$Sound <- factor(datafile$Sound, levels = c("1Quiet", "2SS", "3CS")) #Set up the order of the levels of the Sound conditions
levels(datafile$Sound) # "1Quiet" "2SS" "3CS" 
head(datafile) # Generally check the file

#Step2: Add contrasts
contrasts(datafile$Difficulty) <- contr.sdif(2) #2 levels of difficulty: 1Easy, 2Hard
contrasts(datafile$Sound) <- contr.sdif(3) #3 levels of sound: 1Quiet, 2SS, 3CS

#Step3: Run the model(s)
# 11b. Remove one slope for pp - IT CONVERGED, BUT THE CORRELATION BETWEEN PP AND DIFFICULTY IN RANDOM EFFECTS WAS HIGH (0.86)
Adepvar.glmer11b = glmer(depvar ~ Difficulty * Sound  + (1 + Difficulty|pp) + (1|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer11b, corr = FALSE)

# 12a. Again without correlation for pp - IT CONVERGED, BUT THE CORRELATION BETWEEN PP AND DIFFICULTY IN RANDOM EFFECTS WAS HIGH (0.98)
Adepvar.glmer12a = glmer(depvar ~ Difficulty * Sound +  (0 + Difficulty|pp) + (1|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer12a, corr = FALSE)

# 12b. Again without correlation for ppSound - MODEL IS OVERFITTING THE DATA (boundary (singular) fit: see ?isSingular)
Adepvar.glmer12b = glmer(depvar ~ Difficulty * Sound  +  (0 + Sound|pp) + (1|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer12b, corr = FALSE)

# 13. Intercepts only - FINAL
Adepvar.glmer13 = glmer(depvar ~ Difficulty * Sound + (1|pp) + (1|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer13, corr = FALSE)

#Step4: Calculate Confidence Interaction for the model that converges
Confint.glmer13 = confint(Adepvar.glmer13, method="Wald") #NOT SURE, TO CHECK WHEN TO RUN IT

#### 5. Print model, CI, and graph ####
sink("Experiment1_SolutionRate_Model13.txt")
summary(Adepvar.glmer13, corr=FALSE)
sink()

sink("Experiment1_SolutionRate_CI13.txt")
Confint.glmer13
sink()

#Graphs to see the interaction
jpeg('Experiment1_SolutionRate_graphInteraction13.jpeg')
allEffects(Adepvar.glmer13)# call the particular model you want to see all the effect of
plot(allEffects(Adepvar.glmer13), multiline = TRUE)
dev.off()

#### EXPERIMENT 2 ####
#### 1. Set up working directory and data to use ####
rm(list=ls()) # Remove any variables
setwd("C:/Users/Federica/Documents/UCLan/research/John Marsh/JCognitivePsychology") # Set the working directory
getwd()

datafile = read.csv("Experiment2.csv", header=TRUE,sep = ",",dec=".") # Replace the name of the file with the one that you're analysing
head(datafile) # Generally check the file you have imported

#Rename column 'condition' with 'Sound'
colnames(datafile)[5] <- "Sound"
head(datafile)

#Create a new variable 'newcondition'
datafile$newcondition[datafile$Sound == "Quiet" & datafile$Difficulty== "Easy"] <-1
datafile$newcondition[datafile$Sound == "Quiet" & datafile$Difficulty== "Hard"] <-2
datafile$newcondition[datafile$Sound == "SS" & datafile$Difficulty== "Easy"] <-3
datafile$newcondition[datafile$Sound == "SS" & datafile$Difficulty== "Hard"] <-4
datafile$newcondition[datafile$Sound == "CS" & datafile$Difficulty=="Easy"] <-5
datafile$newcondition[datafile$Sound == "CS" & datafile$Difficulty== "Hard"] <-6
head(datafile)

table(datafile$newcondition) #cond1: 360; cond2: 324; cond3: 360; cond4: 324; cond5: 360; cond6: 324
table(datafile$Sound) #CS: 684, quiet: 684, SS: 684.
table(datafile$Difficulty) #Easy: 1080, Hard: 972.

#### 2. Set up variables ####
colnames(datafile) #checked the column names
col.subject =1   # specify which column your participant number is in
col.condition =7 # specify which column contains your condition number ('newcondition' column)
col.stim =3 # specify which column your item number is in
measure =  "Correct" # choose dependent variable, replace the name of the measure with the one that you're analysing

#Add to dataframe the DV
datafile$depvar = datafile[,measure]
head(datafile) # Generally check the file

#Add to dataframe the fixed and random factors columns
datafile$pp = datafile[,col.subject]
datafile$condition = datafile[,col.condition]
datafile$stim = datafile[,col.stim]
head(datafile) # Generally check the file

#Make sure all variables are correct class
datafile$depvar = as.numeric(datafile$depvar)
datafile$stim = as.factor(datafile$stim)
datafile$condition = as.factor(datafile$condition)
datafile$Sound = as.factor(datafile$Sound)
datafile$Difficulty = as.factor(datafile$Difficulty)
datafile$Set = as.factor(datafile$Set)
str(datafile)

#### 3. Means,Standard Deviations and Standard Errors ####
#Step1a: make a matrix with the means per subject and per condition for the dependent variable
mean.matrix = tapply(datafile$depvar, list(datafile$pp, datafile$condition), mean, na.rm = T)
mean.matrix

#Step1b: make a matrix with the standard deviations per subject and per condition for the dependent variable
sd.matrix = tapply(datafile$depvar, list(datafile$pp, datafile$condition), sd, na.rm = T)
sd.matrix

#Step2:Calculate the grand mean by condition 
grand.mean=apply(mean.matrix, 2, mean, na.rm = T)
grand.mean
grand.sd=apply(mean.matrix,2,sd, na.rm = T)
grand.sd
grand.se=grand.sd/sqrt(36) ##The number of the participants is 36. 
grand.se

sink("Experiment2_SolutionRate_Means&SD&SE.txt")
grand.mean
grand.sd
grand.se
sink()

#### 4. Linear Mixed Models (LMM)####
#Step1: Check the levels of Difficulty and Sound
head(datafile) # Generally check the file
levels(datafile$Difficulty) # "Easy", "Hard"
levels(datafile$Difficulty)[match("Easy",levels(datafile$Difficulty))] <- "1Easy"
levels(datafile$Difficulty)[match("Hard",levels(datafile$Difficulty))] <- "2Hard"
levels(datafile$Difficulty) # "1Easy", "2Hard"

levels(datafile$Sound) # "CS"    "Quiet" "SS"  
levels(datafile$Sound)[match("Quiet",levels(datafile$Sound))] <- "1Quiet"
levels(datafile$Sound)[match("SS",levels(datafile$Sound))] <- "2SS"
levels(datafile$Sound)[match("CS",levels(datafile$Sound))] <- "3CS"
datafile$Sound <- factor(datafile$Sound, levels = c("1Quiet", "2SS", "3CS")) #Set up the order of the levels of the Sound conditions
levels(datafile$Sound) # "1Quiet" "2SS" "3CS" 
head(datafile) # Generally check the file

#Step2: Add contrasts
contrasts(datafile$Difficulty) <- contr.sdif(2) #2 levels of difficulty: Easy, Hard
contrasts(datafile$Sound) <- contr.sdif(3) #3 levels of sound: 1Quiet, 2SS, 3CS

#Step3: Run the model(s)
# 13. Intercepts only - MODEL IS OVERFITTING THE DATA (boundary (singular) fit: see ?isSingular)
Adepvar.glmer13 = glmer(depvar ~ Difficulty * Sound + (1|pp) + (1|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer13, corr = FALSE)

#14. Removing the participant random structure - MODEL IS OVERFITTING THE DATA (boundary (singular) fit: see ?isSingular)
Adepvar.glmer14 = glmer(depvar ~ Difficulty * Sound + (1|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer14, corr = FALSE)

#15. Removing the item random structure - FINAL
Adepvar.glmer15 = glmer(depvar ~ Difficulty * Sound + (1|pp), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer15, corr = FALSE)


#Step4: Calculate Confidence Interaction for the model that converges
Confint.glmer15 = confint(Adepvar.glmer15, method="Wald") #NOT SURE, TO CHECK WHEN TO RUN IT

#### 5. Print model, CI, and graph ####
sink("Experiment2_SolutionRate_Model15.txt")
summary(Adepvar.glmer15, corr=FALSE)
sink()

sink("Experiment2_SolutionRate_CI15.txt")
Confint.glmer15
sink()

#Graphs to see the interaction
jpeg('Experiment2_SolutionRate_graphInteraction15.jpeg')
allEffects(Adepvar.glmer15)# call the particular model you want to see all the effect of
plot(allEffects(Adepvar.glmer15), multiline = TRUE)
dev.off()

#### EXPERIMENT 3 ####
#### 1. Set up working directory and data to use ####
rm(list=ls()) # Remove any variables
setwd("C:/Users/Federica/Documents/UCLan/research/John Marsh/JCognitivePsychology") # Set the working directory
getwd()

datafile = read.csv("Experiment3.csv", header=TRUE,sep = ",",dec=".") # Replace the name of the file with the one that you're analysing
head(datafile) # Generally check the file you have imported

#Rename column 'condition' with 'Sound'
colnames(datafile)[5] <- "Sound"
head(datafile)

#Create a new variable 'newcondition'
datafile$newcondition[datafile$Sound == "quiet" & datafile$Difficulty== "Easy"] <-1
datafile$newcondition[datafile$Sound == "quiet" & datafile$Difficulty== "Hard"] <-2
datafile$newcondition[datafile$Sound == "reversed" & datafile$Difficulty== "Easy"] <-3 #meaningless
datafile$newcondition[datafile$Sound == "reversed" & datafile$Difficulty== "Hard"] <-4 #meaningless
datafile$newcondition[datafile$Sound == "forward" & datafile$Difficulty=="Easy"] <-5 #meaningful
datafile$newcondition[datafile$Sound == "forward" & datafile$Difficulty== "Hard"] <-6 #meaningful
head(datafile)

table(datafile$newcondition) #cond1: 300; cond2: 300; cond3: 300; cond4: 300; cond5: 300; cond6: 300
table(datafile$Sound) #forward: 600, quiet: 600, reversed: 600
table(datafile$Difficulty) #Easy: 900, Hard: 900

#### 2. Set up variables ####
colnames(datafile) #checked the column names
col.subject =1   # specify which column your participant number is in
col.condition =8 # specify which column contains your condition number ('newcondition' column)
col.stim =3 # specify which column your item number is in
measure =  "Correct" # choose dependent variable, replace the name of the measure with the one that you're analysing

#Add to dataframe the DV
datafile$depvar = datafile[,measure]
head(datafile) # Generally check the file

#Add to dataframe the fixed and random factors column
datafile$pp = datafile[,col.subject]
datafile$condition = datafile[,col.condition]
datafile$stim = datafile[,col.stim]
head(datafile) # Generally check the file

#Make sure all variables are correct class
datafile$depvar = as.numeric(datafile$depvar)
datafile$stim = as.factor(datafile$stim)
datafile$condition = as.factor(datafile$condition)
datafile$Sound = as.factor(datafile$Sound)
datafile$Difficulty = as.factor(datafile$Difficulty)
datafile$Set = as.factor(datafile$Set)
str(datafile)

#### 3. Means,Standard Deviations and Standard Errors ####
#Step1a: make a matrix with the means per subject and per condition for the dependent variable
mean.matrix = tapply(datafile$depvar, list(datafile$pp, datafile$condition), mean, na.rm = T)
mean.matrix

#Step1b: make a matrix with the standard deviations per subject and per condition for the dependent variable
sd.matrix = tapply(datafile$depvar, list(datafile$pp, datafile$condition), sd, na.rm = T)
sd.matrix

#Step2:Calculate the grand mean by condition 
grand.mean=apply(mean.matrix, 2, mean, na.rm = T)
grand.mean
grand.sd=apply(mean.matrix,2,sd, na.rm = T)
grand.sd
grand.se=grand.sd/sqrt(30) ##The number of the participants is 30. 
grand.se

sink("Experiment3_SolutionRate_Means&SD&SE.txt")
grand.mean
grand.sd
grand.se
sink()

#### 4. Linear Mixed Models (LMM)####
#Step1: Check the levels of Difficulty and Sound
head(datafile) # Generally check the file
levels(datafile$Difficulty) # "Easy", "Hard"
levels(datafile$Difficulty)[match("Easy",levels(datafile$Difficulty))] <- "1Easy"
levels(datafile$Difficulty)[match("Hard",levels(datafile$Difficulty))] <- "2Hard"
levels(datafile$Difficulty) # "1Easy", "2Hard"

levels(datafile$Sound) # "forward"  "quiet"    "reversed" 
levels(datafile$Sound)[match("quiet",levels(datafile$Sound))] <- "1quiet"
levels(datafile$Sound)[match("reversed",levels(datafile$Sound))] <- "2reversed"
levels(datafile$Sound)[match("forward",levels(datafile$Sound))] <- "3forward"
datafile$Sound <- factor(datafile$Sound, levels = c("1quiet", "2reversed", "3forward")) #Set up the order of the levels of the Sound conditions
levels(datafile$Sound) # "1quiet"    "2reversed" "3forward" 
head(datafile) # Generally check the file

#Step2: Add contrasts
contrasts(datafile$Difficulty) <- contr.sdif(2) #2 levels of difficulty: Easy, Hard
contrasts(datafile$Sound) <- contr.sdif(3) #3 levels of sound: 1quiet, 2reversed, 3forward

#Step3: Run the model(s)
# 11b. Remove one slope for pp - FINAL
Adepvar.glmer11b = glmer(depvar ~ Difficulty * Sound  + (1 + Difficulty|pp) + (1|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer11b, corr = FALSE)

#Step4: Calculate Confidence Interaction for the model that converges
Confint.glmer11b = confint(Adepvar.glmer11b, method="Wald")

#### 5. Print model, CI, and graph ####
sink("Experiment3_SolutionRate_Model11b.txt")
summary(Adepvar.glmer11b, corr=FALSE)
sink()

sink("Experiment3_SolutionRate_CI11b.txt")
Confint.glmer11b
sink()

#Graphs to see the interaction
jpeg('Experiment3_SolutionRate_graphInteraction11b.jpeg')
allEffects(Adepvar.glmer11b)# call the particular model you want to see all the effect of
plot(allEffects(Adepvar.glmer11b), multiline = TRUE)
dev.off()

##### ############################################################################################# #### 

#### MODELS ####
#1. Full model
Adepvar.glmer1 = glmer(depvar ~ Difficulty * Sound + (1 + Difficulty * Sound |pp) + (1 + Difficulty * Sound |stim), datafile, family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))

#If it doesn't converge, then you will need to run one model at the time in the following order (see below), until you find a model that reaches convergence.

# 2. Remove correlations of item
Adepvar.glmer2 = glmer(depvar ~ Difficulty * Sound + (1 + Difficulty * Sound|pp) + (0 + Difficulty * Sound|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer2, corr = FALSE)

# 3. Remove interactions (with correlation back in) of item
Adepvar.glmer3 = glmer(depvar ~ Difficulty * Sound + (1 + Difficulty *Sound|pp) + (1 + Difficulty + Sound|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer3, corr = FALSE)

# 4. Remove correlation and interactions of item
Adepvar.glmer4 = glmer(depvar ~ Difficulty *Sound  + (1 + Difficulty * Sound|pp) + (0 + Difficulty + Sound|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer4, corr = FALSE)

# 5a. Remove one of the slopes
Adepvar.glmer5a = glmer(depvar ~ Difficulty * Sound  + (1 + Difficulty * Sound|pp) + (1 + Difficulty|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer5a, corr = FALSE)

# 5b. Remove one of the slopes
Adepvar.glmer5b = glmer(depvar ~ Difficulty * Sound + (1 + Difficulty * Sound|pp) + (1 + Sound|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer5b, corr = FALSE)

# 6a. Again, without correlation
Adepvar.glmer6a = glmer(depvar ~ Difficulty * Sound  + (1 + Difficulty * Sound|pp) +  (0 + Difficulty|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer6a, corr = FALSE)

# 6b. Again, without correlation
Adepvar.glmer6b = glmer(depvar ~ Difficulty * Sound + (1 + Difficulty * Sound|pp) +  (0 + Sound|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer6b, corr = FALSE)

# 7. Intercept only for items
Adepvar.glmer7 = glmer(depvar ~ Difficulty * Sound  + (1 + Difficulty * Sound|pp) + (1|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer7, corr = FALSE)

# 8. Remove correlation for pp
Adepvar.glmer8 = glmer(depvar ~ Difficulty * Sound + (0 + Difficulty * Sound|pp) + (1|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer8, corr = FALSE)

# 9. Remove interaction (but with correlation back in) for pp
Adepvar.glmer9 = glmer(depvar ~ Difficulty * Sound + (1 + Difficulty + Sound|pp) + (1|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer9, corr = FALSE)

# 10. Remove interaction and correlation for pp
Adepvar.glmer10 = glmer(depvar ~ Difficulty * Sound + (0 + Difficulty + Sound|pp) + (1|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer10, corr = FALSE)

# 11a. Remove one slope for pp
Adepvar.glmer11a = glmer(depvar ~ Difficulty * Sound + (1 + Sound|pp) + (1|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer11a, corr = FALSE)

# 11b. Remove one slope for pp
Adepvar.glmer11b = glmer(depvar ~ Difficulty * Sound  + (1 + Difficulty|pp) + (1|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer11b, corr = FALSE)

# 12a. Again without correlation for pp
Adepvar.glmer12a = glmer(depvar ~ Difficulty * Sound +  (0 + Difficulty|pp) + (1|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer12a, corr = FALSE)

# 12b. Again without correlation for ppSound
Adepvar.glmer12b = glmer(depvar ~ Difficulty * Sound  +  (0 + Sound|pp) + (1|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer12b, corr = FALSE)

# 13. Intercepts only 
Adepvar.glmer13 = glmer(depvar ~ Difficulty * Sound + (1|pp) + (1|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer13, corr = FALSE)

#14. Removing the participant random structure
Adepvar.glmer14 = glmer(depvar ~ Difficulty * Sound + (1|stim), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer14, corr = FALSE)

#15. Removing the item random structure
Adepvar.glmer15 = glmer(depvar ~ Difficulty * Sound + (1|pp), datafile,family = binomial, control=glmerControl(optimizer="bobyqa",optCtrl=list(maxfun=10000)))
summary(Adepvar.glmer15, corr = FALSE)
##### ############################################################################################# #### 

